#ifndef DMCONVERT_H
#define DMCONVERT_H

#include <config.h>

#if HAVE_LOCALE_H
#	include <locale.h>
#endif
#if !HAVE_SETLOCALE
#	define setlocale(Category, Locale)	do { } while (0)
#endif

#ifdef ENABLE_NLS
#	include <libintl.h>
#	define _(Text) gettext (Text)
#else
#	undef bindtextdomain
#	define bindtextdomain(Domain, Directory)	do { } while (0)
#	undef textdomain
#	define textdomain(Domain)	do { } while (0)
#	undef dcgettext
#	define dcgettext(Domainname, Text, Category) Text
#	define _(Text) Text
#endif
#define N_(Text) (Text)

#define DMC_NAME_BASE   "dmconvtmp"
#define DMC_NAME_SOURCE "src"
#define DMC_NAME_DEST   "dst"
#define DMC_NAME_BOUNCE "bounce"

#define DMC_DEV_SOURCE  0
#define DMC_DEV_DEST    1
#define DMC_DEV_BOUNCE  2
#define DMC_DEV_COUNT	3

#define SECTOR_SHIFT    9
#define SECTOR_SIZE     (1 << SECTOR_SHIFT)

#define DM_KERNEL_NAME	"device-mapper"

#define DM_NAME_MAX		256

struct dm_dev {
	unsigned int major;
	unsigned int minor;
	char *name;
};

#define DM_DEV_BUFSIZE	32
#define DM_DEV_NAME(d)	((d).name)
#define DM_DEV_FORMAT(tmp, d)	\
								(sprintf((tmp), "%u:%u", (d).major, (d).minor), (tmp))

struct context {
	uint64_t offset;
	uint64_t size;
	struct dm_dev temps[DMC_DEV_COUNT];
	char *source, *dest;
	unsigned int bsize;
	unsigned int blocks;
	int fd_source;
	int fd_dest;
	void *buffer;
};

/* utility functions */

int is_dm_major(unsigned int major);
unsigned int first_dm_major(void);
int parse_dm_dev(const char *dev, unsigned int *major, unsigned int *minor);
int lookup_dm_dev(char *dest, unsigned int major, unsigned int minor);
int is_temp_dev(const char *dev, pid_t *pid);
void setup_temp_names(struct dm_dev *list);

int inspect_device(const char *dev, struct context *ctx);
int setup_bounce_target(struct context *ctx);
int capture_temp_targets(struct context *ctx, const struct dm_dev *temps);
int swap_source_table(struct context *ctx, int dir);
int remove_temp_targets(struct context *ctx);
int remove_bounce_target(struct context *ctx);
int rename_dest_target(struct context *ctx);
int start_bounce_target(struct context *ctx);
int step_bounce_target(struct context *ctx);
int flush_bounce_target(struct context *ctx, uint64_t done);
int init_device_bounce(struct context *ctx);
int finish_device_bounce(struct context *ctx);

int conversion_setup(struct context *ctx, const char *source,
                     const char *dest);
int conversion_reopen_source(struct context *ctx);
int conversion_init(struct context *ctx, const char *source,
                    const char *dest, int resume);
int conversion_step(struct context *ctx);
int conversion_exit(struct context *ctx);

#endif /* DMCONVERT_H */
